<?php
// Google reCaptcha secret key
$secretKey  = "InsertGoogleReCaptchaApiSecretKey";

$statusMsg = '';
if(isset($_POST['submit'])){
    if(isset($_POST['captcha-response']) && !empty($_POST['captcha-response'])){
        // Get verify response data
        $verifyResponse = file_get_contents('https://www.google.com/recaptcha/api/siteverify?secret='.$secretKey.'&response='.$_POST['captcha-response']);
        $responseData = json_decode($verifyResponse);
        if($responseData->success){
            // Contact form submission code goes here...
            $name = !empty($_POST['name'])?$_POST['name']:'';
            $email = !empty($_POST['email'])?$_POST['email']:'';
            $message = !empty($_POST['message'])?$_POST['message']:'';
            
            $contactFrmStatus = array(
                'type' => 'success',
                'msg' => 'Your contact request have submitted successfully.'
            );
        }else{
            $contactFrmStatus = array(
                'type' => 'error',
                'msg' => 'Robot verification failed, please try again.'
            );
        }
    }else{
        $contactFrmStatus = array(
            'type' => 'error',
            'msg' => 'Robot verification failed, please try again.'
        );
    }
}
?>

<!DOCTYPE html>
<html lang="en-US">
<head>
<title>Google Invisible reCAPTCHA by CodexWorld</title>
<meta charset="utf-8">
<link href="style.css" rel="stylesheet">

<script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback" async defer></script>
<script>
var onloadCallback = function() {
    grecaptcha.execute();
};

function setResponse(response) { 
    document.getElementById('captcha-response').value = response; 
} 
</script>
</head>
<body>

<div class="container">
    <div class="contact-frm">
        <form action="" method="post">
            <h3>Contact Form</h3>
            <h4>Contact us for custom quote</h4>
            <?php
            // Display form submission status
            if(!empty($contactFrmStatus['msg'])){
                echo '<p class="'.$contactFrmStatus['type'].'">'.$contactFrmStatus['msg'].'</p>';
            }
            ?>
            <fieldset>
                <input type="text" name="name" placeholder="Your name" required >
            </fieldset>
            <fieldset>
                <input type="email" name="email" placeholder="Your Email Address" required>
            </fieldset>
            <fieldset>
                <textarea name="message" placeholder="Type your message here...." required></textarea>
            </fieldset>
            <fieldset>
                <!-- Google reCAPTCHA widget -->
                <div class="g-recaptcha" data-sitekey="InsertGoogleReCaptchaApiSiteKey" data-badge="inline" data-size="invisible" data-callback="setResponse"></div>
            </fieldset>
            <fieldset>
                <input type="hidden" id="captcha-response" name="captcha-response" />
                <input type="submit" name="submit" value="SUBMIT">
            </fieldset>
        </form>
    </div>
</div>
</body>
</html>