<?php
/*
 * Facebook OAuth
 */
// Include the autoloader provided in the SDK
require_once __DIR__ . '/social_oauth_lib/facebook-php-sdk/autoload.php';

// Include required libraries
use Facebook\Facebook;
use Facebook\Exceptions\FacebookResponseException;
use Facebook\Exceptions\FacebookSDKException;

$fb = new Facebook(array(
	'app_id' => FB_APP_ID,
	'app_secret' => FB_APP_SECRET,
	'default_graph_version' => 'v2.10',
    'persistent_data_handler' => 'session'
));

// Get redirect login helper
$helper = $fb->getRedirectLoginHelper();

if(isset($_GET['state'])){
    $_SESSION['FBRLH_state'] = $_GET['state'];
}

if((isset($_REQUEST['state']) && isset($_REQUEST['code'])) || isset($_SESSION['facebook_access_token'])){
    // Try to get access token
    try {
        if(isset($_SESSION['facebook_access_token'])){
            $fbAccessToken = $_SESSION['facebook_access_token'];
        }else{
            $fbAccessToken = $helper->getAccessToken(SOCIAL_REDIRECT_URL);
        }
    } catch(FacebookResponseException $e) {
        echo 'Graph returned an error: ' . $e->getMessage();
        exit;
    } catch(FacebookSDKException $e) {
        echo 'Facebook SDK returned an error: ' . $e->getMessage();
        exit;
    }
}

if(isset($fbAccessToken)){
	if(isset($_SESSION['facebook_access_token'])){
		$fb->setDefaultAccessToken($_SESSION['facebook_access_token']);
	}else{
		// Put short-lived access token in session
		$_SESSION['facebook_access_token'] = (string) $fbAccessToken;
		
	  	// OAuth 2.0 client handler helps to manage access tokens
		$oAuth2Client = $fb->getOAuth2Client();
		
		// Exchanges a short-lived access token for a long-lived one
		$longLivedAccessToken = $oAuth2Client->getLongLivedAccessToken($_SESSION['facebook_access_token']);
		$_SESSION['facebook_access_token'] = (string) $longLivedAccessToken;
		
		// Set default access token to be used in script
		$fb->setDefaultAccessToken($_SESSION['facebook_access_token']);
	}
	
	// Redirect the user back to the same page if url has "code" parameter in query string
	if(isset($_GET['code'])){
		header('Location: ./');
		exit;
	}
	
	// Getting user facebook profile info
	try {
		$profileRequest = $fb->get('/me?fields=name,first_name,last_name,email,link,gender,locale,picture');
		$fbUserProfile = $profileRequest->getGraphNode()->asArray();
	} catch(FacebookResponseException $e) {
		echo 'Graph returned an error: ' . $e->getMessage();
		session_destroy();
		// Redirect user back to app login page
		header("Location: ./");
		exit;
	} catch(FacebookSDKException $e) {
		echo 'Facebook SDK returned an error: ' . $e->getMessage();
		exit;
	}
	
	// Initialize User class
	$user = new User();
    
    // Getting user profile info
	$fbUserData = array();
	$fbUserData['oauth_uid']  = !empty($fbUserProfile['id'])?$fbUserProfile['id']:'';
	$fbUserData['first_name'] = !empty($fbUserProfile['first_name'])?$fbUserProfile['first_name']:'';
	$fbUserData['last_name']  = !empty($fbUserProfile['last_name'])?$fbUserProfile['last_name']:'';
	$fbUserData['email'] 	  = !empty($fbUserProfile['email'])?$fbUserProfile['email']:'';
	$fbUserData['gender'] 	  = !empty($fbUserProfile['gender'])?$fbUserProfile['gender']:'';
	$fbUserData['locale'] 	  = !empty($fbUserProfile['locale'])?$fbUserProfile['locale']:'';
	$fbUserData['picture'] 	  = !empty($fbUserProfile['picture']['url'])?$fbUserProfile['picture']['url']:'';
	$fbUserData['link'] 	  = !empty($fbUserProfile['link'])?$fbUserProfile['link']:'';
	
	// Insert or update user data to the database
    $fbUserData['oauth_provider'] = 'facebook';
	$userData = $user->checkUser($fbUserData);
	
	// Get logout url
	$logoutURL = $helper->getLogoutUrl($fbAccessToken, BASE_URL.'userAccount.php?logoutSubmit=1');
	
    // Store login status into the session
    $sessData['userLoggedIn'] = TRUE;
    $sessData['userID'] = $userData['id'];
	$sessData['loginType'] = 'social';
    $_SESSION['sessData'] = $sessData;
    
    // Redirect to my account
    header("Location: account.php");
	exit();
}else{
	// Get login url
	$fbLoginURL = $helper->getLoginUrl(SOCIAL_REDIRECT_URL, array('email'));
	$fbLoginURL = filter_var($fbLoginURL, FILTER_SANITIZE_URL);
}


/*
 * Google OAuth
 */
// Include Google client library
require_once 'social_oauth_lib/google-php-client/Google_Client.php';
require_once 'social_oauth_lib/google-php-client/contrib/Google_Oauth2Service.php';

// Call Google API
$gClient = new Google_Client();
$gClient->setApplicationName('Login to CodexWorld.com');
$gClient->setClientId(GP_CLIENT_ID);
$gClient->setClientSecret(GP_CLIENT_SECRET);
$gClient->setRedirectUri(SOCIAL_REDIRECT_URL);

$google_oauthV2 = new Google_Oauth2Service($gClient);

if(isset($_GET['code'])){
	$gClient->authenticate($_GET['code']);
	$_SESSION['google_access_token'] = $gClient->getAccessToken();
	header('Location: ' . filter_var(BASE_URL, FILTER_SANITIZE_URL));
	exit;
}

if(isset($_SESSION['google_access_token'])){
	$gClient->setAccessToken($_SESSION['google_access_token']);
}

if($gClient->getAccessToken() && !isset($_GET['logoutSubmit'])){
	// Get user profile data from google
	$gpUserProfile = $google_oauthV2->userinfo->get();
	
	// Initialize User class
	$user = new User();
	
	// Getting user profile info
	$gpUserData = array();
	$gpUserData['oauth_uid']  = !empty($gpUserProfile['id'])?$gpUserProfile['id']:'';
	$gpUserData['first_name'] = !empty($gpUserProfile['given_name'])?$gpUserProfile['given_name']:'';
	$gpUserData['last_name']  = !empty($gpUserProfile['family_name'])?$gpUserProfile['family_name']:'';
	$gpUserData['email'] 	  = !empty($gpUserProfile['email'])?$gpUserProfile['email']:'';
	$gpUserData['gender'] 	  = !empty($gpUserProfile['gender'])?$gpUserProfile['gender']:'';
	$gpUserData['locale'] 	  = !empty($gpUserProfile['locale'])?$gpUserProfile['locale']:'';
	$gpUserData['picture'] 	  = !empty($gpUserProfile['picture'])?$gpUserProfile['picture']:'';
	$gpUserData['link'] 	  = !empty($gpUserProfile['link'])?$gpUserProfile['link']:'';
	
	// Insert or update user data to the database
    $gpUserData['oauth_provider'] = 'google';
    $userData = $user->checkUser($gpUserData);
	
	// Store login status into the session
    $sessData['userLoggedIn'] = TRUE;
    $sessData['userID'] = $userData['id'];
	$sessData['loginType'] = 'social';
    $_SESSION['sessData'] = $sessData;
    
    // Redirect to my account
    header("Location: account.php");
	exit();
}else{
	$gpLoginURL = $gClient->createAuthUrl();
	$gpLoginURL = filter_var($gpLoginURL, FILTER_SANITIZE_URL);
}

/*
 * Twitter OAuth
 */
// Include Twitter client library 
require_once 'social_oauth_lib/twitter-php-oauth/twitteroauth.php';

// If OAuth token not matched
if(isset($_REQUEST['oauth_token']) && $_SESSION['twitter_access_token'] !== $_REQUEST['oauth_token']){
	// Remove token from session
	unset($_SESSION['twitter_access_token']);
	unset($_SESSION['twitter_token_secret']);
}

// If user already verified 
if(isset($_SESSION['status']) && $_SESSION['status'] == 'verified' && !empty($_SESSION['request_vars'])){
	// Retrive variables from session
	$username 		  = $_SESSION['request_vars']['screen_name'];
	$twitterId		  = $_SESSION['request_vars']['user_id'];
	$oauthToken 	  = $_SESSION['request_vars']['oauth_token'];
	$oauthTokenSecret = $_SESSION['request_vars']['oauth_token_secret'];
	$profilePicture	  = $_SESSION['userData']['picture'];
	
}elseif(isset($_REQUEST['oauth_token']) && $_SESSION['twitter_access_token'] == $_REQUEST['oauth_token']){
	// Call Twitter API
	$twClient = new TwitterOAuth(TW_CONSUMER_KEY, TW_CONSUMER_SECRET, $_SESSION['twitter_access_token'] , $_SESSION['twitter_token_secret']);
	
	// Get OAuth token
	$tw_access_token = $twClient->getAccessToken($_REQUEST['oauth_verifier']);
	
	// If returns success
	if($twClient->http_code == '200'){
		// Storing access token data into session
		$_SESSION['status'] = 'verified';
		$_SESSION['request_vars'] = $tw_access_token;
		
		// Get user profile data from twitter
		$userInfo = $twClient->get('account/verify_credentials', ['include_email' => 'true']);

		// Initialize User class
		$user = new User();
		
		// Getting user profile info
        $name = explode(" ", $userInfo->name);
        $twUserData = array();
        $twUserData['oauth_uid']  = !empty($userInfo->id)?$userInfo->id:'';
        $twUserData['first_name'] = !empty($name[0])?$name[0]:'';
        $twUserData['last_name']  = !empty($name[1])?$name[1]:'';
        $twUserData['email'] 	  = !empty($userInfo->email)?$userInfo->email:'';
        $twUserData['gender'] 	  = '';
        $twUserData['locale'] 	  = !empty($userInfo->lang)?$userInfo->lang:'';
        $twUserData['picture'] 	  = !empty($userInfo->profile_image_url)?$userInfo->profile_image_url:'';
        $twUserData['link'] 	  = !empty($userInfo->screen_name)?'https://twitter.com/'.$userInfo->screen_name:'';
        $twUserData['username']   = !empty($userInfo->screen_name)?$userInfo->screen_name:'';
        
        // Insert or update user data to the database
        $twUserData['oauth_provider'] = 'twitter';
		$userData = $user->checkUser($twUserData);
		
		// Store login status into the session
        $sessData['userLoggedIn'] = TRUE;
        $sessData['userID'] = $userData['id'];
		$sessData['loginType'] = 'social';
        $_SESSION['sessData'] = $sessData;
		
		// Remove oauth token and secret from session
		unset($_SESSION['twitter_access_token']);
		unset($_SESSION['twitter_token_secret']);
		
		// Redirect to my account
        header("Location: account.php");
        exit();
	}
}else{
	// Fresh authentication
	$twClient = new TwitterOAuth(TW_CONSUMER_KEY, TW_CONSUMER_SECRET);
	$request_token = $twClient->getRequestToken(SOCIAL_REDIRECT_URL);
	
	// Received token info from twitter
	$_SESSION['twitter_access_token'] = $request_token['oauth_token'];
	$_SESSION['twitter_token_secret'] = $request_token['oauth_token_secret'];
	
	// If authentication returns success
	if($twClient->http_code == '200'){
		// Get twitter oauth url
		$twLoginURL = $twClient->getAuthorizeURL($request_token['oauth_token']);
		$twLoginURL = filter_var($twLoginURL, FILTER_SANITIZE_URL);
	}
}
?>