<?php
// Start session
if(!session_id()){
	session_start();
}

// Get current page file name
$pageFile = basename($_SERVER['PHP_SELF']);

// Include config file && User class
require_once 'config.php';
require_once 'User.class.php';

// Check whether user ID is available in cookie
if(isset($_COOKIE['rememberUserId']) && !empty($rememberUserId)){
	$_SESSION['sessData']['userLoggedIn'] = TRUE;
	$_SESSION['sessData']['userId'] = $rememberUserId;
}

// Get session data
$sessData = !empty($_SESSION['sessData'])?$_SESSION['sessData']:array();

// Redirect to homepage if user not logged in
$userLoggedIn = (!empty($sessData['userLoggedIn']) && !empty($sessData['userID']))?true:false;
switch($pageFile){
	case 'account.php':
	case 'edit-account.php':
	case 'settings.php':
		if($userLoggedIn){
			$user = new User();
			$conditions['where'] = array(
				'id' => $sessData['userID'],
			);
			$conditions['return_type'] = 'single';
			$userData = $user->getRows($conditions);
			
			$httpPos = strpos($userData['picture'], 'http');
			if($httpPos === false){
				$userPicture = !empty($userData['picture'])?UPLOAD_URL.'profile_picture/'.$userData['picture']:PUBLIC_URL.'images/default.png';
			}else{
				$userPicture = $userData['picture'];
			}
			$userName = $userData['first_name'].' '.$userData['last_name'];
		}else{
			header("Location: index.php");
			exit();
		}
		break;
	case 'forgotPassword.php':
	case 'registration.php':
	case 'resetPassword.php':
		if($userLoggedIn){
			header("Location: account.php");
			exit();
		}
		break;
	case 'index.php':
		if($userLoggedIn){
			header("Location: account.php");
			exit();
		}else{
			// Include social login handler
			require_once 'socialLogin.php';
		}
	default:
		$userData = array();	
}

// Get status message from session
if(!empty($sessData['status']['msg'])){
    $statusMsg = $sessData['status']['msg'];
    $statusMsgType = $sessData['status']['type'];
    unset($_SESSION['sessData']['status']);
}