<?php
// Include config & login validate file
require_once 'includes/validateUser.php';

if(isset($_SESSION['sessData']['field_error'])){
	// Get form field error from session
	$fieldError = $_SESSION['sessData']['field_error'];
	
	// Remove field error data from session
	unset($_SESSION['field_error']['sessData']);
}

?>
<!DOCTYPE html>
<html lang="en-US">
<head>
	<!--head-->
	<?php include_once 'elements/head.php'; ?>
	<!--//head-->
</head>
<body>
<div class="container">
    
    <!--header-->
    <?php include_once 'elements/header.php'; ?>
    <!--//header-->
    
    <!--main-->
	<div class="main-content">
		<div class="wrapper-frm">
            <div class="head-menu">
                <div class="menu-tle">
                    <h2>Update Account</h2>
                </div>
                <div class="top-nav">
                    <span class="menu"><img src="<?php echo PUBLIC_URL; ?>images/menu.png" alt=""></span>
                    <?php include_once 'elements/nav_menu.php'; ?>
                    <div class="clearfix"> </div>
                </div>
            </div>
            <div class="ucontent">
                <div class="right-pnl">
                    <img src="<?php echo $userPicture; ?>" alt="<?php echo $userName; ?>">
                    <h2><?php echo $userName; ?></h2>
                </div>
                <div class="left-pnl">
					<?php echo !empty($statusMsg)?'<p class="status-msg '.$statusMsgType.'">'.$statusMsg.'</p>':''; ?>
                    <form action="<?php echo BASE_URL; ?>userAccount.php" method="post" enctype="multipart/form-data">
						<div class="frm-input">
                            <input type="file" name="picture" class="file-in" placeholder="Choose Image File">
                        </div>
                        <div class="frm-input <?php echo !empty($fieldError['first_name'])?'error':''; ?>">
                            <input type="text" name="first_name" class="user-in" placeholder="First name" value="<?php echo !empty($userData['first_name'])?$userData['first_name']:''; ?>" required="">
							<?php echo !empty($fieldError['first_name'])?'<p>'.$fieldError['first_name'].'</p>':''; ?>
                        </div>
                        <div class="frm-input <?php echo !empty($fieldError['last_name'])?'error':''; ?>"">
                            <input type="text" name="last_name" class="user-in" placeholder="Last name" value="<?php echo !empty($userData['last_name'])?$userData['last_name']:''; ?>" required="">
							<?php echo !empty($fieldError['last_name'])?'<p>'.$fieldError['last_name'].'</p>':''; ?>
                        </div>
                        <div class="frm-input <?php echo !empty($sessData['field_error']['email'])?'error':''; ?>"">
                            <input type="email" name="email" class="email-in" placeholder="Email" value="<?php echo !empty($userData['email'])?$userData['email']:''; ?>" required="">
							<?php echo !empty($fieldError['email'])?'<p>'.$fieldError['email'].'</p>':''; ?>
                        </div>
                        <div class="frm-input">
                            <input type="text" name="phone" class="phone-in" placeholder="Phone" value="<?php echo !empty($userData['phone'])?$userData['phone']:''; ?>">
                        </div>
                        <div class="frm-input">
                            <input type="text" name="address" class="addr-in" placeholder="Address" value="<?php echo !empty($userData['address'])?$userData['address']:''; ?>">
                        </div>
                        <div class="frm-btn">
                            <input type="submit" name="updateProfile" value="Update">
                        </div>
                    </form>
                </div> 
            </div>
		</div>
	</div>
	<!--//main-->
    
	<!--footer-->
	<?php include_once 'elements/footer.php'; ?>
	<!--//footer-->
</div>
</body>
</html>