<?php
// Email sending functions
include_once 'includes/email_functions.php';

// Start session
if(!session_id()){
	session_start();
}

// Include config file
require_once 'includes/config.php';

// Load and initialize user class
require_once 'includes/User.class.php';
$user = new User();

if(isset($_POST['signupSubmit'])){
	$valErr = 0;
	
	// Store post data into session
	$_SESSION['signup_post_data'] = $_POST;
	
	// Get user inputs
	$first_name = $_POST['first_name'];
	$last_name = $_POST['last_name'];
	$email = $_POST['email'];
	$phone = $_POST['phone'];
	$address = $_POST['address'];
	$password = $_POST['password'];
	$confirm_password = $_POST['confirm_password'];
	
	if(empty($first_name)){
		$valErr = 1;
		$sessData['field_error']['first_name'] = 'Please enter your first name.';
	}
	if(empty($last_name)){
		$valErr = 1;
		$sessData['field_error']['last_name'] = 'Please enter your last name.';
	}
	if(empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)){
		$valErr = 1;
		$sessData['field_error']['email'] = 'Please enter a valid email.';
	}
	if(empty($password)){
		$valErr = 1;
		$sessData['field_error']['password'] = 'Please enter account password.';
	}
	if(empty($confirm_password)){
		$valErr = 1;
		$sessData['field_error']['confirm_password'] = 'Please confirm your password.';
	}elseif($password !== $confirm_password){
		$valErr = 1;
		$sessData['field_error']['confirm_password'] = 'Confirm password must match with the password.';
	}

	if($valErr == 0){
		// Check whether user exists in the database
		$cond['where'] = array('email' => $email);
		$cond['return_type'] = 'count';
		$userCount = $user->getRows($cond);
		if($userCount > 0){
			$sessData['status']['type'] = 'error';
			$sessData['status']['msg'] = 'Email already exists, please use another email.';
		}else{
			// Email verification code
			$uniqidStr = md5(uniqid(mt_rand()));
			
			// Insert user data in the database
			$userData = array(
				'first_name' => $first_name,
				'last_name' => $last_name,
				'email' => $email,
				'password' => password_hash($password, PASSWORD_DEFAULT),
				'phone' => $phone,
				'address' => $address,
				'activation_code' => $uniqidStr
			);
			$insert = $user->insert($userData);
			
			// Set status based on data insert
			if($insert){
				// Remove post data from session
				unset($_SESSION['signup_post_data']);
				
				// Send account verification email
				@emailVerification($userData);
				
				$sessData['status']['type'] = 'success';
				$sessData['status']['msg'] = 'Your registration was successfully. Please check your email to verify and activate your account.';
				
				// Remove post data from session
				unset($_SESSION['signup_post_data']);
			}else{
				$sessData['status']['type'] = 'error';
				$sessData['status']['msg'] = 'Some problem occurred, please try again.';
			}
		}
	}else{
        $sessData['status']['type'] = 'error';
        $sessData['status']['msg'] = 'Please fill all the mandatory fields.'; 
    }
	
	// Store signup status into the session
    $_SESSION['sessData'] = $sessData;
    $redirectURL = ($sessData['status']['type'] == 'success')?'index.php':'registration.php';
	
	// Redirect to the home/login page
    header("Location:".$redirectURL);
	exit;
}elseif(isset($_POST['loginSubmit'])){
	// Get user inputs
	$email = $_POST['email'];
	$password = $_POST['password'];
	
	// Check whether login details are empty
    if(!empty($email) && !empty($password)){
		// Get user data from user class
        $conditions['where'] = array(
            'email' => $email,
            'status' => '1'
        );
        $conditions['return_type'] = 'single';
        $userData = $user->getRows($conditions);
		
		if(!empty($userData) && password_verify($password, $userData['password'])){
			// Set user data and status based on login credentials
			if($userData['activated'] == '0'){
				$sessData['status']['type'] = 'error';
				$sessData['status']['msg'] = 'Your account activation is pending, please check your email to verify and activate your account.';
			}else{
				// If remember me is checked
				if (isset($_POST['rememberMe']) && $_POST['rememberMe'] == 1) {
					setcookie('rememberUserId', $userData['id'], time() + (86400));
				}
				
				$sessData['userLoggedIn'] = TRUE;
				$sessData['userID'] = $userData['id'];
				$sessData['status']['type'] = 'success';
				$sessData['status']['msg'] = 'Welcome '.$userData['first_name'].'!';
			}
		}else{
			$sessData['status']['type'] = 'error';
            $sessData['status']['msg'] = 'Wrong email or password, please try again.'; 
		}
    }else{
        $sessData['status']['type'] = 'error';
        $sessData['status']['msg'] = 'Enter email and password.'; 
    }
	
	// Store login status into the session
    $_SESSION['sessData'] = $sessData;
	
	// Redirect to the home page
    header("Location:index.php");
	exit;
}elseif(isset($_POST['forgotSubmit'])){
	$frmDisplay = '';
	
	// Get user inputs
	$email = $_POST['email'];
	
	// Check whether email is empty
    if(!empty($email)){
		// Check whether user exists in the database
		$cond['where'] = array('email' => $email);
		$cond['return_type'] = 'count';
		$userCount = $user->getRows($cond);
		if($userCount > 0){
			// Generat unique string
			$uniqidStr = md5(uniqid(mt_rand()));
			
			// Update data with forgot pass code
			$conditions = array(
				'email' => $email
			);
			$data = array(
				'forgot_pass_identity' => $uniqidStr
			);
			$update = $user->update($data, $conditions);
			
			if($update){
				// Get user details
				$con['where'] = array('email' => $email);
				$con['return_type'] = 'single';
				$userDetails = $user->getRows($con);
				
				// Send reset password email
                @forgotPassEmail($userDetails);
				
				$sessData['status']['type'] = 'success';
				$sessData['status']['msg'] = 'Please check your e-mail, we have sent a password reset link to your registered email.';
				$frmDisplay = '?frmDis=0';
			}else{
				$sessData['status']['type'] = 'error';
				$sessData['status']['msg'] = 'Some problem occurred, please try again.';
			}
		}else{
			$sessData['status']['type'] = 'error';
			$sessData['status']['msg'] = 'Given email is not associated with any account.'; 
		}
		
    }else{
        $sessData['status']['type'] = 'error';
        $sessData['status']['msg'] = 'Enter email to create a new password for your account.'; 
    }
	
	// Store reset password status into the session
    $_SESSION['sessData'] = $sessData;
	
	// Redirect to the forgot pasword page
    header("Location:forgotPassword.php".$frmDisplay);
}elseif(isset($_POST['resetSubmit'])){
	$fp_code = $_POST['fp_code'];
	
	// Get user inputs
	$password = $_POST['password'];
	$confirm_password = $_POST['confirm_password'];
	
	if(!empty($password) && !empty($confirm_password) && !empty($fp_code)){
		// Password and confirm password comparison
        if($password !== $confirm_password){
            $sessData['status']['type'] = 'error';
            $sessData['status']['msg'] = 'Confirm password must match with the password.'; 
        }else{
			//check whether identity code exists in the database
            $cond['where'] = array('forgot_pass_identity' => $fp_code);
            $cond['return_type'] = 'count';
            $userCount = $user->getRows($cond);
            if($userCount > 0){
				// Update data with new password
				$conditions = array(
					'forgot_pass_identity' => $fp_code
				);
				$data = array(
					'password' => password_hash($password, PASSWORD_DEFAULT)
				);
				$update = $user->update($data, $conditions);
				if($update){
					$sessData['status']['type'] = 'success';
                    $sessData['status']['msg'] = 'Your account password has been reset successfully. Please login with your new password.';
				}else{
					$sessData['status']['type'] = 'error';
					$sessData['status']['msg'] = 'Some problem occurred, please try again.';
				}
            }else{
                $sessData['status']['type'] = 'error';
                $sessData['status']['msg'] = 'You does not authorized to reset new password of this account.';
            }
        }
    }else{
        $sessData['status']['type'] = 'error';
        $sessData['status']['msg'] = 'All fields are mandatory, please fill all the fields.'; 
    }
	
	// Store reset password status into the session
    $_SESSION['sessData'] = $sessData;
    $redirectURL = ($sessData['status']['type'] == 'success')?'index.php':'resetPassword.php?fp_code='.$fp_code;
	
	// Redirect to the login/reset pasword page
    header("Location:".$redirectURL);
	exit;
}elseif(isset($_REQUEST['verifyEmail']) && $_REQUEST['verifyEmail'] == 1){
	$ac_code = $_REQUEST['ac_code'];

	// Check whether activation code exists in the database
	$cond['where'] = array('activation_code' => $ac_code);
	$cond['return_type'] = 'count';
	$userCount = $user->getRows($cond);
	if($userCount > 0){
		// Update data with new password
		$conditions = array(
			'activation_code' => $ac_code
		);
		$data = array(
			'activated' => '1'
		);
		$update = $user->update($data, $conditions);
		if($update){
			$sessData['status']['type'] = 'success';
			$sessData['status']['msg'] = 'Email verification for your account was successful. Please login to your account.';
		}else{
			$sessData['status']['type'] = 'error';
			$sessData['status']['msg'] = 'Some problem occurred, please try again.';
		}
	}else{
		$sessData['status']['type'] = 'error';
		$sessData['status']['msg'] = 'You have clicked on the wrong verification link, please check your email and try again.';
	}
	
	// Store account activation status into the session
    $_SESSION['sessData'] = $sessData;
    $redirectURL = 'index.php';
	
	//Redirect to the login page
    header("Location:".$redirectURL);
	exit;
}elseif(isset($_POST['updateProfile']) && !empty($_SESSION['sessData']['userID'])){
	$valErr = 0;
	
	$sessData = $_SESSION['sessData'];
	$sessUserId = $sessData['userID'];
	
	// Get user inputs
	$first_name = $_POST['first_name'];
	$last_name = $_POST['last_name'];
	$email = $_POST['email'];
	$phone = $_POST['phone'];
	$address = $_POST['address'];
	
	if(empty($first_name)){
		$valErr = 1;
		$sessData['field_error']['first_name'] = 'Please enter your first name.';
	}
	if(empty($last_name)){
		$valErr = 1;
		$sessData['field_error']['last_name'] = 'Please enter your last name.';
	}
	if(empty($email) || !filter_var($email, FILTER_VALIDATE_EMAIL)){
		$valErr = 1;
		$sessData['field_error']['email'] = 'Please enter a valid email.';
	}

	if($valErr == 0){
		// Check whether user exists in the database
		$cond['where'] = array('email' => $email);
		$cond['where_not'] = array('id' => $sessUserId);
		$cond['return_type'] = 'count';
		$userCount = $user->getRows($cond);
		if($userCount > 0){
			$sessData['status']['type'] = 'error';
			$sessData['status']['msg'] = 'Email already exists, please use another email.';
		}else{
			// Get user information
			$conditions['where'] = array(
				'id' => $sessData['userID'],
			);
			$conditions['return_type'] = 'single';
			$userData = $user->getRows($conditions);
			$prevPicture = $userData['picture'];
			
			// Prepare user data 
			$userData = array(
				'first_name' => $first_name,
				'last_name' => $last_name,
				'email' => $email,
				'phone' => $phone,
				'address' => $address
			);
			
			// Profile picture upload
			$fileErr = 0;
			if(isset($_FILES['picture']['name']) && $_FILES['picture']['name'] != ""){
				$targetDir = UPLOAD_PATH.'profile_picture/';
				$fileName = time().'_'.basename($_FILES["picture"]["name"]);
				$targetFilePath = $targetDir. $fileName;
				$fileType = pathinfo($targetFilePath,PATHINFO_EXTENSION);
				$allowTypes = array('jpg','png','jpeg','gif');
				if(in_array($fileType, $allowTypes)){
					if(move_uploaded_file($_FILES["picture"]["tmp_name"], $targetFilePath)){
						$userData['picture'] = $fileName;
						
						// Delete previous profile picture
						@unlink(UPLOAD_PATH.'profile_picture/'.$prevPicture);
					}
				}else{
					$fileErr = 1;
					$sessData['status']['type'] = 'error';
					$sessData['status']['msg'] = 'Please select only jpg/png/gif file.';
				}
			}
			
			if($fileErr == 0){
				// Update user data in the database
				$conditions = array(
					'id' => $sessUserId
				);
				$update = $user->update($userData, $conditions);
				
				// Set status based on data insert
				if($update){
					$sessData['status']['type'] = 'success';
					$sessData['status']['msg'] = 'Your profile information has been updated successfully.';
				}else{
					$sessData['status']['type'] = 'error';
					$sessData['status']['msg'] = 'Some problem occurred, please try again.';
				}
			}
		}
    }else{
        $sessData['status']['type'] = 'error';
        $sessData['status']['msg'] = 'Please fill all the mandatory fields.'; 
    }
	
	// Store signup status into the session
    $_SESSION['sessData'] = $sessData;
	$redirectURL = 'edit-account.php';
	
	//redirect to the profile page
    header("Location:".$redirectURL);
	exit;
}elseif(isset($_POST['updatePassword']) && !empty($_SESSION['sessData']['userID'])){
	$sessData = $_SESSION['sessData'];
	$sessUserId = $sessData['userID'];
	
	// Get user inputs
	$old_password = $_POST['old_password'];
	$password = $_POST['password'];
	$confirm_password = $_POST['confirm_password'];
	
	if(!empty($password) && !empty($confirm_password)){
		// Password and confirm password comparison
        if($password !== $confirm_password){
            $sessData['status']['type'] = 'error';
            $sessData['status']['msg'] = 'Confirm password must match with the password.'; 
        }else{
			// Check whether identity code exists in the database
			$cond['where'] = array('id' => $sessUserId);
            $cond['return_type'] = 'single';
            $userData = $user->getRows($cond);
			
			if((!empty($userData) && !empty($sessData['loginType']) && $sessData['loginType'] == 'social') || (!empty($userData) && password_verify($old_password, $userData['password']))){
				// Update data with new password
				$conditions = array(
					'id' => $sessUserId
				);
				$data = array(
					'password' => password_hash($password, PASSWORD_DEFAULT)
				);
				$update = $user->update($data, $conditions);
				if($update){
					$sessData['status']['type'] = 'success';
                    $sessData['status']['msg'] = 'Your account password has been updated successfully.';
				}else{
					$sessData['status']['type'] = 'error';
					$sessData['status']['msg'] = 'Some problem occurred, please try again.';
				}
            }else{
                $sessData['status']['type'] = 'error';
                $sessData['status']['msg'] = 'The given old password does not match with your account password.';
            }
        }
    }else{
        $sessData['status']['type'] = 'error';
        $sessData['status']['msg'] = 'Please fill all the mandatory fields.'; 
    }
	
	// Store reset password status into the session
    $_SESSION['sessData'] = $sessData;
    $redirectURL = 'settings.php';
	
	// Redirect to the pasword settings page
    header("Location:".$redirectURL);
	exit;
}elseif(!empty($_REQUEST['logoutSubmit'])){
	// Include social login handler
	if(!empty($_SESSION['sessData']['loginType']) && ($_SESSION['sessData']['loginType'] == 'social') && !empty($_SESSION['google_access_token'])){
		require_once 'includes/socialLogin.php';
	}
	
	// Remove cookie data
	setcookie("rememberUserId", "", time() - 3600);
	
	// Remove session data
	unset($_SESSION['facebook_access_token']);
	unset($_SESSION['FBRLH_state']);
	if(isset($_SESSION['google_access_token'])){
		// Reset OAuth access token
		$gClient->revokeToken();
	}
	unset($_SESSION['google_access_token']);
	unset($_SESSION['twitter_access_token']);
	unset($_SESSION['twitter_token_secret']);
    unset($_SESSION['sessData']);
    session_destroy();
	
	// Store logout status into the ession
    $sessData['status']['type'] = 'success';
    $sessData['status']['msg'] = 'You have logout successfully from your account.';
    $_SESSION['sessData'] = $sessData;
	
	// Redirect to the home page
    header("Location:index.php");
	exit;
}else{
	// Redirect to the home page
    header("Location:index.php");
	exit;
}